<?php
/* --------------------------------------------------------------
 Path.php 2021-05-14
 Gambio GmbH
 http://www.gambio.de
 Copyright (c) 2020 Gambio GmbH
 Released under the GNU General Public License (Version 2)
 [http://www.gnu.org/licenses/gpl-2.0.html]
 --------------------------------------------------------------
 */

declare(strict_types=1);

namespace Gambio\Core\Application\ValueObjects;

/**
 * Class Path
 *
 * @package Gambio\Core\Application\ValueObjects
 */
class Path
{
    /** @var string $base */
    private string $base;
    
    /** @var string  $admin */
    private string $admin;

    /** @var string $config */
    private string $config;

    /** @var string $logfiles */
    private string $logfiles;


    /**
     * Url constructor.
     *
     * @param string $base
     */
    public function __construct(string $base)
    {
        $this->base  = $base;
        $this->admin = "{$base}/admin";
        $this->config = "{$base}/config";
        $this->logfiles = "{$base}/logfiles";
    }
    
    
    /**
     * Returns base path of the shop root directory.
     *
     * @return string
     */
    public function base(): string
    {
        return $this->base;
    }
    
    
    /**
     * Returns the base path of the admins root directory.
     *
     * @return string
     */
    public function admin(): string
    {
        return $this->admin;
    }

    /**
     * Returns the base path of the config root directory.
     *
     * @return string
     */
    public function getConfigDir(): string
    {
        return $this->config;
    }

    /**
     * Returns the base path of the logs root directory.
     *
     * @return string
     */
    public function getLogfilesDir(): string
    {
        return $this->logfiles;
    }
}